/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.collection.primitive.impl.standard;

import com.teacode.collection.primitive.LongList;
import com.teacode.collection.primitive.impl.standard.StdHelper;
import com.teacode.collection.primitive.process.LongProcessor;
import java.util.ArrayList;
import java.util.List;

public class StdLongList
implements LongList {
    private final List<Long> list;

    public StdLongList(int size) {
        this.list = new ArrayList<Long>(size);
    }

    public final void clear() {
        this.list.clear();
    }

    public final void insert(int index, long value) {
        this.list.add(index, value);
    }

    public final int indexOf(int index, long value) {
        int size = this.list.size();
        for (int t = index; t < size; ++t) {
            if (this.list.get(t) != value) continue;
            return t;
        }
        return -1;
    }

    public final long get(int index) {
        return this.list.get(index);
    }

    public final boolean forEach(LongProcessor processor) {
        for (Long i : this.list) {
            if (processor.process(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean contains(long value) {
        return this.list.contains(value);
    }

    public final void add(long value) {
        this.list.add(value);
    }

    public final void addAll(long[] values) {
        for (long value : values) {
            this.list.add(value);
        }
    }

    public final int size() {
        return this.list.size();
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void removeValue(long value) {
        this.list.remove(value);
    }

    public final void removeIndex(int index) {
        this.list.remove(index);
    }

    public final long[] toArray() {
        return StdHelper.toArray(this.list);
    }
}

