/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.collection.primitive.impl.trove;

import com.teacode.collection.primitive.BooleanList;
import com.teacode.collection.primitive.process.BooleanProcessor;
import gnu.trove.TByteArrayList;
import gnu.trove.TByteProcedure;

public class TroveBooleanList
implements BooleanList {
    private final TByteArrayList list;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;

    public TroveBooleanList(int size) {
        this.list = new TByteArrayList(size);
    }

    public final void add(boolean value) {
        this.list.add(value ? (byte)1 : 0);
    }

    public final int size() {
        return this.list.size();
    }

    public final void insert(int index, boolean value) {
        this.list.insert(index, value ? (byte)1 : 0);
    }

    public final int indexOf(int index, boolean value) {
        return this.list.indexOf(index, value ? (byte)1 : 0);
    }

    public final void removeIndex(int index) {
        this.list.remove(index);
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean get(int index) {
        return this.list.get(index) == 1;
    }

    public boolean forEach(final BooleanProcessor processor) {
        return this.list.forEach(new TByteProcedure(){

            public boolean execute(byte b) {
                return processor.process(b == 1);
            }
        });
    }
}

