/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.component;

import com.teacode.swing.CommonRB;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.Timer;

public class HeapButton
extends JButton
implements ActionListener {
    public HeapButton() {
        super("-");
        this.setToolTipText(CommonRB.get("gc.run"));
        this.setActionCommand("gc");
        this.addActionListener(this);
        this.refreshMemoryStatus();
        Timer timer = new Timer(5000, this);
        timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if ("gc".equals(e.getActionCommand())) {
            Runtime.getRuntime().gc();
        }
        this.refreshMemoryStatus();
    }

    protected void refreshMemoryStatus() {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        long used = total - free;
        long max = rt.maxMemory();
        String text = this.conv(used) + "/" + this.conv(total) + " (" + this.conv(max) + ")";
        this.setText(" " + text + " ");
    }

    protected String conv(long total) {
        total /= 1024L;
        return String.valueOf(total /= 1024L) + "M";
    }
}

