/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.table;

import com.teacode.swing.table.BaseTableModel;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleTableModel<D>
extends BaseTableModel<D> {
    protected SimpleTableModel(String firstColumn, String ... columns) {
        super(firstColumn, columns);
    }

    public synchronized void replaceAll(List<D> newData) {
        HashSet<Long> oldIds = new HashSet<Long>(this.data.size());
        for (Object d : this.data) {
            oldIds.add(this.getDataId(d));
        }
        for (Object d : newData) {
            long newId = this.getDataId(d);
            if (oldIds.contains(newId)) {
                this.replaceData(d);
                continue;
            }
            this.addData(d);
        }
        for (Object d : newData) {
            oldIds.remove(this.getDataId(d));
        }
        for (Long id : oldIds) {
            int index = this.findData(id);
            if (index == -1 || !this.processBeforeRemove(this.getData(index))) continue;
            this.removeRow(index);
        }
    }

    public synchronized void replaceAllSorted(List<D> newData, Comparator<D> comparator) {
        HashSet<Long> oldIds = new HashSet<Long>(this.data.size());
        for (Object d : this.data) {
            oldIds.add(this.getDataId(d));
        }
        for (Object d : newData) {
            long newId = this.getDataId(d);
            if (oldIds.contains(newId)) {
                this.replaceData(d);
                continue;
            }
            this.addDataSorted(d, comparator);
        }
        for (Object d : newData) {
            oldIds.remove(this.getDataId(d));
        }
        for (Long id : oldIds) {
            int index = this.findData(id);
            if (index == -1 || !this.processBeforeRemove(this.getData(index))) continue;
            this.removeRow(index);
        }
    }

    protected boolean replaceData(D d) {
        int index = this.findData(d);
        if (index == -1) {
            return false;
        }
        this.setData(index, d);
        return true;
    }

    public synchronized int findData(long id) {
        int size = this.data.size();
        for (int t = 0; t < size; ++t) {
            Object d = this.data.get(t);
            if (this.getDataId(d) != id) continue;
            return t;
        }
        return -1;
    }

    public synchronized int findData(D dataToFind) {
        return this.findData(this.getDataId(dataToFind));
    }

    protected abstract long getDataId(D var1);

    protected boolean processBeforeRemove(D d) {
        return true;
    }
}

