/*
 * Decompiled with CFR 0.152.
 */
package com.teacode.swing.tool;

import com.teacode.swing.component.PopupClipboardMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class SelectTextMouseListener
implements MouseListener {
    protected Copyable copyable;
    protected PopupClipboardMenu menu;

    public SelectTextMouseListener(Copyable copyable) {
        this.copyable = copyable;
        this.menu = new PopupClipboardMenu(copyable);
    }

    public void mouseClicked(MouseEvent e) {
    }

    protected void popup(int x, int y) {
        this.menu.refresh();
        this.menu.show(this.copyable.getJComponent(), x, y);
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public static JPopupMenu install(JTextComponent textComponent) {
        return SelectTextMouseListener.install(new JTextComponentCopyable(textComponent));
    }

    public static JPopupMenu install(Copyable copyable) {
        SelectTextMouseListener listener = new SelectTextMouseListener(copyable);
        copyable.getJComponent().addMouseListener(listener);
        return listener.menu;
    }

    public static class JTextComponentCopyable
    implements Copyable {
        protected JTextComponent tc;

        public JTextComponentCopyable(JTextComponent comp) {
            this.tc = comp;
        }

        public JComponent getJComponent() {
            return this.tc;
        }

        public boolean isEditable() {
            return this.tc.isEditable();
        }

        public boolean isSelectAllSupported() {
            return true;
        }

        public boolean isSelected() {
            return this.tc.getSelectedText() != null;
        }

        public void copy() {
            this.tc.copy();
        }

        public void cut() {
            this.tc.cut();
        }

        public void paste() {
            this.tc.paste();
        }

        public void selectAll() {
            this.tc.selectAll();
        }
    }

    public static interface Copyable {
        public JComponent getJComponent();

        public boolean isEditable();

        public boolean isSelectAllSupported();

        public boolean isSelected();

        public void copy();

        public void cut();

        public void paste();

        public void selectAll();
    }
}

